/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
::   Module      :   Unhandled Soft ISR Header
::   Copyright   :   (C)2002-2009 Woodward
::   Platform(s) :   MPC5xx
::   Limitations :   MPC5xx OS
::   $Workfile: UnhandledSISR.h $
::
::-----------------------------------------------------------------------------------------------------------
::
::   Operating System Code
::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

#ifndef __UNHANDLEDSISR_H
#define __UNHANDLEDSISR_H

/*----- INCLUDES ------------------------------------------------------------------------------------------*/
#include <typedefn.h>

/*----- DEFINES -------------------------------------------------------------------------------------------*/

/*----- TYPEDEFS ------------------------------------------------------------------------------------------*/
#pragma pack(1)

typedef enum /* Name: E_ExternalISRType ClassID:ENUMDEC EnumDflt:"NoIllegalISRs" */
{
    NoExternalISR = 0,
    ExternalISR_IRM0 = 1,        /*  EnumTxt:"ExternalISR_IRM0" */
    ExternalISR_LVL0 = 2,        /*  EnumTxt:"ExternalISR_LVL0" */
    ExternalISR_IRM1 = 3,        /*  EnumTxt:"ExternalISR_IRM1" */
    ExternalISR_LVL1 = 4,        /*  EnumTxt:"ExternalISR_LVL1" */
    ExternalISR_IRM2 = 5,        /*  EnumTxt:"ExternalISR_IRM2" */
    ExternalISR_LVL2 = 6,        /*  EnumTxt:"ExternalISR_LVL2" */
    ExternalISR_IRM3 = 7,        /*  EnumTxt:"ExternalISR_IRM3" */
    ExternalISR_LVL3 = 8,        /*  EnumTxt:"ExternalISR_LVL3" */
    ExternalISR_IRM4 = 9,        /*  EnumTxt:"ExternalISR_IRM4" */
    ExternalISR_LVL4 = 10,       /*  EnumTxt:"ExternalISR_LVL4" */
    ExternalISR_IRM5 = 11,       /*  EnumTxt:"ExternalISR_IRM5" */
    ExternalISR_LVL5 = 12,       /*  EnumTxt:"ExternalISR_LVL5" */
    ExternalISR_IRM6 = 13,       /*  EnumTxt:"ExternalISR_IRM6" */
    ExternalISR_LVL6 = 14,       /*  EnumTxt:"ExternalISR_LVL6" */
    ExternalISR_IRM7 = 15,       /*  EnumTxt:"ExternalISR_IRM7" */
    ExternalISR_LVL7 = 16,       /*  EnumTxt:"ExternalISR_LVL7" */
    ISR_TPUA_CHAN0   = 17,       /*  EnumTxt:"ISR_TPUA_CHAN0" */
    ISR_TPUA_CHAN1   = 18,       /*  EnumTxt:"ISR_TPUA_CHAN1" */
    ISR_TPUA_CHAN2   = 19,       /*  EnumTxt:"ISR_TPUA_CHAN2" */
    ISR_TPUA_CHAN3   = 20,       /*  EnumTxt:"ISR_TPUA_CHAN3" */
    ISR_TPUA_CHAN4   = 21,       /*  EnumTxt:"ISR_TPUA_CHAN4" */
    ISR_TPUA_CHAN5   = 22,       /*  EnumTxt:"ISR_TPUA_CHAN5" */
    ISR_TPUA_CHAN6   = 23,       /*  EnumTxt:"ISR_TPUA_CHAN6" */
    ISR_TPUA_CHAN7   = 24,       /*  EnumTxt:"ISR_TPUA_CHAN7" */
    ISR_TPUA_CHAN8   = 25,       /*  EnumTxt:"ISR_TPUA_CHAN8" */
    ISR_TPUA_CHAN9   = 26,       /*  EnumTxt:"ISR_TPUA_CHAN9" */
    ISR_TPUA_CHAN10  = 27,       /*  EnumTxt:"ISR_TPUA_CHAN10" */
    ISR_TPUA_CHAN11  = 28,       /*  EnumTxt:"ISR_TPUA_CHAN11" */
    ISR_TPUA_CHAN12  = 29,       /*  EnumTxt:"ISR_TPUA_CHAN12" */
    ISR_TPUA_CHAN13  = 30,       /*  EnumTxt:"ISR_TPUA_CHAN13" */
    ISR_TPUA_CHAN14  = 31,       /*  EnumTxt:"ISR_TPUA_CHAN14" */
    ISR_TPUA_CHAN15  = 32,       /*  EnumTxt:"ISR_TPUA_CHAN15" */
    ISR_TPUB_CHAN0   = 33,       /*  EnumTxt:"ISR_TPUB_CHAN0" */
    ISR_TPUB_CHAN1   = 34,       /*  EnumTxt:"ISR_TPUB_CHAN1" */
    ISR_TPUB_CHAN2   = 35,       /*  EnumTxt:"ISR_TPUB_CHAN2" */
    ISR_TPUB_CHAN3   = 36,       /*  EnumTxt:"ISR_TPUB_CHAN3" */
    ISR_TPUB_CHAN4   = 37,       /*  EnumTxt:"ISR_TPUB_CHAN4" */
    ISR_TPUB_CHAN5   = 38,       /*  EnumTxt:"ISR_TPUB_CHAN5" */
    ISR_TPUB_CHAN6   = 39,       /*  EnumTxt:"ISR_TPUB_CHAN6" */
    ISR_TPUB_CHAN7   = 40,       /*  EnumTxt:"ISR_TPUB_CHAN7" */
    ISR_TPUB_CHAN8   = 41,       /*  EnumTxt:"ISR_TPUB_CHAN8" */
    ISR_TPUB_CHAN9   = 42,       /*  EnumTxt:"ISR_TPUB_CHAN9" */
    ISR_TPUB_CHAN10  = 43,       /*  EnumTxt:"ISR_TPUB_CHAN10" */
    ISR_TPUB_CHAN11  = 44,       /*  EnumTxt:"ISR_TPUB_CHAN11" */
    ISR_TPUB_CHAN12  = 45,       /*  EnumTxt:"ISR_TPUB_CHAN12" */
    ISR_TPUB_CHAN13  = 46,       /*  EnumTxt:"ISR_TPUB_CHAN13" */
    ISR_TPUB_CHAN14  = 47,       /*  EnumTxt:"ISR_TPUB_CHAN14" */
    ISR_TPUB_CHAN15  = 48,       /*  EnumTxt:"ISR_TPUB_CHAN15" */
    ISR_MIOS1_CHAN0 = 49,        /*  EnumTxt:"ISR_MIOS1_CHAN0" */
    ISR_MIOS1_CHAN1 = 50,        /*  EnumTxt:"ISR_MIOS1_CHAN1" */
    ISR_MIOS1_CHAN2 = 51,        /*  EnumTxt:"ISR_MIOS1_CHAN2" */
    ISR_MIOS1_CHAN3 = 52,        /*  EnumTxt:"ISR_MIOS1_CHAN3" */
    ISR_MIOS1_CHAN4 = 53,        /*  EnumTxt:"ISR_MIOS1_CHAN4" */
    ISR_MIOS1_CHAN5 = 54,        /*  EnumTxt:"ISR_MIOS1_CHAN5" */
    ISR_MIOS1_CHAN6 = 55,        /*  EnumTxt:"ISR_MIOS1_CHAN6" */
    ISR_MIOS1_CHAN7 = 56,        /*  EnumTxt:"ISR_MIOS1_CHAN7" */
    ISR_MIOS1_CHAN8 = 57,        /*  EnumTxt:"ISR_MIOS1_CHAN8" */
    ISR_MIOS1_CHAN9 = 58,        /*  EnumTxt:"ISR_MIOS1_CHAN9" */
    ISR_MIOS1_CHAN10 = 59,       /*  EnumTxt:"ISR_MIOS1_CHAN10" */
    ISR_MIOS1_CHAN11 = 60,       /*  EnumTxt:"ISR_MIOS1_CHAN11" */
    ISR_MIOS1_CHAN12 = 61,       /*  EnumTxt:"ISR_MIOS1_CHAN12" */
    ISR_MIOS1_CHAN13 = 62,       /*  EnumTxt:"ISR_MIOS1_CHAN13" */
    ISR_MIOS1_CHAN14 = 63,       /*  EnumTxt:"ISR_MIOS1_CHAN14" */
    ISR_MIOS1_CHAN15 = 64,       /*  EnumTxt:"ISR_MIOS1_CHAN15" */
    ISR_MIOS1_CHAN16 = 65,       /*  EnumTxt:"ISR_MIOS1_CHAN16" */
    ISR_MIOS1_CHAN17 = 66,       /*  EnumTxt:"ISR_MIOS1_CHAN17" */
    ISR_MIOS1_CHAN18 = 67,       /*  EnumTxt:"ISR_MIOS1_CHAN18" */
    ISR_MIOS1_CHAN19 = 68,       /*  EnumTxt:"ISR_MIOS1_CHAN19" */
    ISR_MIOS1_CHAN20 = 69,       /*  EnumTxt:"ISR_MIOS1_CHAN20" */
    ISR_MIOS1_CHAN21 = 70,       /*  EnumTxt:"ISR_MIOS1_CHAN21" */
    ISR_MIOS1_CHAN22 = 71,       /*  EnumTxt:"ISR_MIOS1_CHAN22" */
    ISR_MIOS1_CHAN23 = 72,       /*  EnumTxt:"ISR_MIOS1_CHAN23" */
    ISR_MIOS1_CHAN24 = 73,       /*  EnumTxt:"ISR_MIOS1_CHAN24" */
    ISR_MIOS1_CHAN25 = 74,       /*  EnumTxt:"ISR_MIOS1_CHAN25" */
    ISR_MIOS1_CHAN26 = 75,       /*  EnumTxt:"ISR_MIOS1_CHAN26" */
    ISR_MIOS1_CHAN27 = 76,       /*  EnumTxt:"ISR_MIOS1_CHAN27" */
    ISR_MIOS1_CHAN28 = 77,       /*  EnumTxt:"ISR_MIOS1_CHAN28" */
    ISR_MIOS1_CHAN29 = 78,       /*  EnumTxt:"ISR_MIOS1_CHAN29" */
    ISR_MIOS1_CHAN30 = 79,       /*  EnumTxt:"ISR_MIOS1_CHAN30" */
    ISR_MIOS1_CHAN31 = 80,       /*  EnumTxt:"ISR_MIOS1_CHAN31" */
    ISR_SCC1_TDRE    = 81,       /*  EnumTxt:"ISR_SCC1_TDRE"    */
    ISR_SCC1_TC      = 82,       /*  EnumTxt:"ISR_SCC1_TC"      */
    ISR_SCC1_RDRF    = 83,       /*  EnumTxt:"ISR_SCC1_RDRF"    */
    ISR_SCC1_IDLE    = 84,       /*  EnumTxt:"ISR_SCC1_IDLE"    */
    ISR_SCC2_TDRE    = 85,       /*  EnumTxt:"ISR_SCC2_TDRE"    */
    ISR_SCC2_TC      = 86,       /*  EnumTxt:"ISR_SCC2_TC"      */
    ISR_SCC2_RDRF    = 87,       /*  EnumTxt:"ISR_SCC2_RDRF"    */
    ISR_SCC2_IDLE    = 88,       /*  EnumTxt:"ISR_SCC2_IDLE"    */
    ISR_TOUCANA_CHAN0 = 81,      /*  EnumTxt:"ISR_TOUCANA_CHAN0"  */
    ISR_TOUCANA_CHAN1 = 82,      /*  EnumTxt:"ISR_TOUCANA_CHAN1"  */
    ISR_TOUCANA_CHAN2 = 83,      /*  EnumTxt:"ISR_TOUCANA_CHAN2"  */
    ISR_TOUCANA_CHAN3 = 84,      /*  EnumTxt:"ISR_TOUCANA_CHAN3"  */
    ISR_TOUCANA_CHAN4 = 85,      /*  EnumTxt:"ISR_TOUCANA_CHAN4"  */
    ISR_TOUCANA_CHAN5 = 86,      /*  EnumTxt:"ISR_TOUCANA_CHAN5"  */
    ISR_TOUCANA_CHAN6 = 87,      /*  EnumTxt:"ISR_TOUCANA_CHAN6"  */
    ISR_TOUCANA_CHAN7 = 88,      /*  EnumTxt:"ISR_TOUCANA_CHAN7"  */
    ISR_TOUCANA_CHAN8 = 89,      /*  EnumTxt:"ISR_TOUCANA_CHAN8"  */
    ISR_TOUCANA_CHAN9 = 90,      /*  EnumTxt:"ISR_TOUCANA_CHAN9"  */
    ISR_TOUCANA_CHAN10 = 91,     /*  EnumTxt:"ISR_TOUCANA_CHAN10" */
    ISR_TOUCANA_CHAN11 = 92,     /*  EnumTxt:"ISR_TOUCANA_CHAN11" */
    ISR_TOUCANA_CHAN12 = 93,     /*  EnumTxt:"ISR_TOUCANA_CHAN12" */
    ISR_TOUCANA_CHAN13 = 94,     /*  EnumTxt:"ISR_TOUCANA_CHAN13" */
    ISR_TOUCANA_CHAN14 = 95,     /*  EnumTxt:"ISR_TOUCANA_CHAN14" */
    ISR_TOUCANA_CHAN15 = 96,     /*  EnumTxt:"ISR_TOUCANA_CHAN15" */
    ISR_TOUCANB_CHAN0  = 97,     /*  EnumTxt:"ISR_TOUCANB_CHAN0"  */
    ISR_TOUCANB_CHAN1  = 98,     /*  EnumTxt:"ISR_TOUCANB_CHAN1"  */
    ISR_TOUCANB_CHAN2  = 99,     /*  EnumTxt:"ISR_TOUCANB_CHAN2"  */
    ISR_TOUCANB_CHAN3  = 100,    /*  EnumTxt:"ISR_TOUCANB_CHAN3"  */
    ISR_TOUCANB_CHAN4  = 101,    /*  EnumTxt:"ISR_TOUCANB_CHAN4"  */
    ISR_TOUCANB_CHAN5  = 102,    /*  EnumTxt:"ISR_TOUCANB_CHAN5"  */
    ISR_TOUCANB_CHAN6  = 103,    /*  EnumTxt:"ISR_TOUCANB_CHAN6"  */
    ISR_TOUCANB_CHAN7  = 104,    /*  EnumTxt:"ISR_TOUCANB_CHAN7"  */
    ISR_TOUCANB_CHAN8  = 105,    /*  EnumTxt:"ISR_TOUCANB_CHAN8"  */
    ISR_TOUCANB_CHAN9  = 106,    /*  EnumTxt:"ISR_TOUCANB_CHAN9"  */
    ISR_TOUCANB_CHAN10 = 107,    /*  EnumTxt:"ISR_TOUCANB_CHAN10" */
    ISR_TOUCANB_CHAN11 = 108,    /*  EnumTxt:"ISR_TOUCANB_CHAN11" */
    ISR_TOUCANB_CHAN12 = 109,    /*  EnumTxt:"ISR_TOUCANB_CHAN12" */
    ISR_TOUCANB_CHAN13 = 110,    /*  EnumTxt:"ISR_TOUCANB_CHAN13" */
    ISR_TOUCANB_CHAN14 = 111,    /*  EnumTxt:"ISR_TOUCANB_CHAN14" */
    ISR_TOUCANB_CHAN15 = 112,    /*  EnumTxt:"ISR_TOUCANB_CHAN15" */
    ISR_TPUC_CHAN0 = 113,        /*  EnumTxt:"ISR_TPUC_CHAN0" */
    ISR_TPUC_CHAN1 = 114,        /*  EnumTxt:"ISR_TPUC_CHAN1" */
    ISR_TPUC_CHAN2 = 115,        /*  EnumTxt:"ISR_TPUC_CHAN2" */
    ISR_TPUC_CHAN3 = 116,        /*  EnumTxt:"ISR_TPUC_CHAN3" */
    ISR_TPUC_CHAN4 = 117,        /*  EnumTxt:"ISR_TPUC_CHAN4" */
    ISR_TPUC_CHAN5 = 118,        /*  EnumTxt:"ISR_TPUC_CHAN5" */
    ISR_TPUC_CHAN6 = 119,        /*  EnumTxt:"ISR_TPUC_CHAN6" */
    ISR_TPUC_CHAN7 = 120,        /*  EnumTxt:"ISR_TPUC_CHAN7" */
    ISR_TPUC_CHAN8 = 121,        /*  EnumTxt:"ISR_TPUC_CHAN8" */
    ISR_TPUC_CHAN9 = 122,        /*  EnumTxt:"ISR_TPUC_CHAN9" */
    ISR_TPUC_CHAN10 = 123,       /*  EnumTxt:"ISR_TPUC_CHAN10" */
    ISR_TPUC_CHAN11 = 124,       /*  EnumTxt:"ISR_TPUC_CHAN11" */
    ISR_TPUC_CHAN12 = 125,       /*  EnumTxt:"ISR_TPUC_CHAN12" */
    ISR_TPUC_CHAN13 = 126,       /*  EnumTxt:"ISR_TPUC_CHAN13" */
    ISR_TPUC_CHAN14 = 127,       /*  EnumTxt:"ISR_TPUC_CHAN14" */
    ISR_TPUC_CHAN15 = 128        /*  EnumTxt:"ISR_TPUC_CHAN15" */
} E_ExternalISRType;

/* This type is used by the Assembler file UnhandledSISR.s so do not alter its */
/* structure without also altering the assembler file */
typedef struct
{
    uint4 R0;
    uint4 R1;
    uint4 R2;
    uint4 R3;
    uint4 R4;
    uint4 R5;
    uint4 R6;
    uint4 R7;
    uint4 R8;
    uint4 R9;
    uint4 R10;
    uint4 R11;
    uint4 R12;
    uint4 R13;
    uint4 R14;
    uint4 R15;
    uint4 R16;
    uint4 R17;
    uint4 R18;
    uint4 R19;
    uint4 R20;
    uint4 R21;
    uint4 R22;
    uint4 R23;
    uint4 R24;
    uint4 R25;
    uint4 R26;
    uint4 R27;
    uint4 R28;
    uint4 R29;
    uint4 R30;
    uint4 R31;
    uint4 ExceptionAddr_SRR0;
    uint4 MachineState_SRR1;
    uint4 IntegerException;
    uint4 CountReg;
    uint4 LinkReg;
    uint4 ConditionCodes;
    uint1 ExceptionType;
    uint1 ExceptionCnt;
} S_ExceptionData;

typedef S_ExceptionData* S_ExceptionDataPtr;

#pragma pack()
/*----- EXTERNALS -----------------------------------------------------------------------------------------*/

/*----- PROTOTYPES ----------------------------------------------------------------------------------------*/

#endif /* __UNHANDLEDSISR_H */

/*----- END OF FILE ---------------------------------------------------------------------------------------*/







